// Google Apps Script (apps_script.gs) for v14
const SPREADSHEET_ID = '1m3dTc4DZxhnIMrW-gl5eLBT9r0NYQIR_uUWUhIFHKtg';
const TARGET_GID = 1812172390;
const ADMIN_SECRET = '9377';

function getSheetByGid_(ss, gid) { for (const sh of ss.getSheets()) if (sh.getSheetId()===gid) return sh; throw new Error('지정한 GID의 시트를 찾을 수 없습니다: '+gid); }
function _json(obj) { return ContentService.createTextOutput(JSON.stringify(obj)).setMimeType(ContentService.MimeType.JSON); }

function doPost(e) {
  try {
    const data = JSON.parse(e.postData.contents);
    const ss = SpreadsheetApp.openById(SPREADSHEET_ID);
    const sheet = getSheetByGid_(ss, TARGET_GID);
    sheet.appendRow([new Date(), String(data.name||''), String(data.phone||'')]);
    return _json({ ok:true });
  } catch (err) { return _json({ ok:false, error:String(err) }) }
}

function doGet(e) {
  try {
    if ((e.parameter.mode||'')==='list') {
      if ((e.parameter.secret||'') !== ADMIN_SECRET) return _json({ ok:false, error:'unauthorized' });
      const ss = SpreadsheetApp.openById(SPREADSHEET_ID);
      const sheet = getSheetByGid_(ss, TARGET_GID);
      const values = sheet.getDataRange().getValues();
      const rows = [];
      for (let i=0;i<values.length;i++) {
        const r = values[i]; if (!r || r.length<3) continue;
        const ts = (r[0] instanceof Date) ? r[0].toISOString() : String(r[0]);
        rows.push({ ts: ts, name: String(r[1]||''), phone: String(r[2]||'') });
      }
      return _json({ ok:true, rows });
    }
    return _json({ ok:true, pong:true });
  } catch(err) { return _json({ ok:false, error:String(err) }) }
}
